local assets=
{
	Asset("ANIM", "anim/warsaw762.zip"),
	Asset("ATLAS", "images/inventoryimages/warsaw762.xml"),
    Asset("IMAGE", "images/inventoryimages/warsaw762.tex"),
}

local prefabs =
{

}

local function OnHit(inst, owner, target)
    inst:Remove()    
end


local function fncommon(Sim)
	local inst = CreateEntity()
	inst.entity:AddTransform()
	inst.entity:AddAnimState()
    MakeInventoryPhysics(inst)
	
	inst.AnimState:SetBank("warsaw762")
    inst.AnimState:SetBuild("warsaw762")
    inst.AnimState:PlayAnimation("idle", false)
    
		
    inst:AddTag("projectile")
	
    inst:AddComponent("stackable")	 
	inst.components.stackable.maxsize = 40
	
	inst:AddComponent("projectile")
    inst.components.projectile:SetSpeed(100)
	inst.components.projectile:SetOnHitFn(OnHit)
    inst.components.projectile:SetOnMissFn(OnHit)
	
    inst:AddComponent("inspectable")
    	
    inst:AddComponent("inventoryitem")
    inst.components.inventoryitem.atlasname = "images/inventoryimages/warsaw762.xml"

	return inst
end



STRINGS.NAMES.WARSAW762 = "7.62x54mm."
STRINGS.CHARACTERS.GENERIC.DESCRIBE.WARSAW762 = "sniper ammo."


return Prefab( "common/inventory/warsaw762", fncommon, assets)
